ad_page_contract {

@author Nick Kokkos
This listbuilder shows the pictures uploaded, and lets you delete or bulk 
delete some or all of them. Mostly created by following the examples in the documentation
and by reading the code under /acs-subsite/members to get an idea how to add sorting by
title and description

} { 
  { orderby "title,asc" }
  page:optional
}

set package_id [ad_conn package_id]

permission::require_permission -object_id $package_id -privilege admin

template::list::create -name photos -multirow photos \
-no_data { No Photos uploaded } \
-page_size [parameter::get -parameter PageSize] \
-page_flush_p t \
-page_query_name photos_pagination \
-bulk_actions {"Remove selected photos" "photo-delete" "Delete Photos" } \
-actions { 
	"Upload a photo" "photo_add" "Click to upload a photo" 
	"Show me the slides!" "slideshow" "Takes you right into the slideshow!" 
	"Set parameters" "set-parameters" "Set parameters for the gallery" } \
-key item_id \
-elements { \
	thumbnail {
		label "Thumbnail" 
		display_template {
		<img src="@photos.viewfilepath_thumb;noquote@" width="100" height="75" border="4">
	        }
  		sub_class narrow 
        }	
	title {
		label "Title" 
		display_col title 
	}
	description { 
	 	label "Description" 
		display_col description  
		sub_class narrow
	}  
	edit {  
            	link_url_col edit_url
            	display_template {
                <img src="/resources/acs-subsite/Edit16.gif" width="16" height="16" border="2">
            	} 
            	sub_class narrow
	}
	delete { 
		
            	link_url_col delete_url
            	display_template {
                <img src="/resources/acs-subsite/Delete16.gif" width="16" height="16" border="2">
            	}   
            	sub_class narrow
        }  
	
} -orderby {
      title {
           label "Title"
           orderby "title"
      } 
      description {
	   label "Description"
           orderby "description"
      } 
} -filters {
	id {}  
}


set parameters_url [export_vars -base "/shared/parameters" {
  package_id { return_url [ad_return_url] }
}]





db_multirow \
 -extend {
  delete_url
  edit_url 
} photos photos_select {} {
set delete_url [export_vars -base "photo-delete" { item_id } ]
set edit_url [export_vars -base "photo_edit" { item_id } ]
}

